// priority: 10000

global.debug = false;

global.resources = [
  "Copper",
  "Diamond",
  "Emerald",
  "Fluorite",
  "Gold",
  "Iron",
  "Lapis",
  "Lead",
  "Nickel",
  "Osmium",
  "Quartz",
  "Redstone",
  "Silver",
  "Tin",
  "Uranium",
  "Aluminum",
  "Platinum",
];

global.materials = [
  ["diamond", 2],
  ["redstone", 12],
  ["emerald", 2],
  ["lapis_lazuli", 12],
  ["quartz", 4],
];

global.compressables = [
  "basalt",
  "clay",
  "cobblestone",
  "dirt",
  "dust",
  "end_stone",
  "gravel",
  "netherrack",
  "red_sand",
  "sand",
  "stone",
  "soul_sand",
  "soul_soil",
];

global.food = [
  ["Fruit", "Fruity"],
  ["Veggies", "Healthy Veggies"],
  ["Meat", "Meat"],
  ["Stew", "Mushroom Stew"],
];

global.pebbles = [
  "Stone",
  "Andesite",
  "Granite",
  "Diorite",
  "Calcite",
  "Deepslate",
  "Tuff",
  "Basalt",
  "Endstone",
  "Netherrack",
  "Sandstone",
  "Red Sandstone",
];

StartupEvents.modifyCreativeTab("kubejs:tab", (event) => {
  event.displayName = "Feed The Beast";
});

global.materialTypes = [
  {
    materials: [
      "aluminum",
      "brass",
      "bronze",
      "chromium",
      "copper",
      "iron",
      "plutonium",
      "silicon",
      "stainless_steel",
      "tin",
      "titanium",
    ],
    type: "blade",
  },
  {
    materials: [
      "aluminum",
      "antimony",
      "apatite",
      "bauxite",
      "brass",
      "bronze",
      "chromium",
      "constantan",
      "electrum",
      "fluorite",
      "graphite",
      "invar",
      "iridium",
      "lead",
      "lumium",
      "monazite",
      "nickel",
      "osmium",
      "platinum",
      "plutonium",
      "refined_glowstone",
      "resonating_ore",
      "silicon",
      "silver",
      "stainless_steel",
      "steel",
      "sulfur",
      "tin",
      "titanium",
      "tungsten",
      "uranium",
      "zinc",
    ],
    type: "block",
  },
  {
    materials: [
      "aluminum",
      "antimony",
      "brass",
      "chromium",
      "diamond",
      "gold",
      "iridium",
      "iron",
      "lead",
      "lumium",
      "nickel",
      "osmium",
      "platinum",
      "plutonium",
      "quartz",
      "silicon",
      "silver",
      "sulfur",
      "tin",
      "titanium",
      "tungsten",
      "uranium",
      "zinc",
    ],
    type: "clump",
  },
  {
    materials: [
      "aluminum",
      "antimony",
      "brass",
      "chromium",
      "diamond",
      "gold",
      "iridium",
      "iron",
      "lead",
      "lumium",
      "nickel",
      "osmium",
      "platinum",
      "plutonium",
      "silicon",
      "silver",
      "sulfur",
      "tin",
      "titanium",
      "tungsten",
      "uranium",
      "zinc",
    ],
    type: "crystal",
  },
  {
    materials: [
      "aluminum",
      "antimony",
      "bauxite",
      "fluorite",
      "iridium",
      "lead",
      "monazite",
      "nickel",
      "osmium",
      "platinum",
      "quartz",
      "resonating_ore",
      "silver",
      "sulfur",
      "tin",
      "titanium",
      "tungsten",
      "uranium",
      "zinc",
    ],
    type: "deepslate_ore",
  },
  {
    materials: [
      "aluminum",
      "antimony",
      "brass",
      "chromium",
      "diamond",
      "gold",
      "iridium",
      "iron",
      "lead",
      "lumium",
      "nickel",
      "osmium",
      "platinum",
      "plutonium",
      "quartz",
      "silicon",
      "silver",
      "sulfur",
      "tin",
      "titanium",
      "tungsten",
      "uranium",
      "zinc",
    ],
    type: "dirty_dust",
  },
  {
    materials: [
      "aluminum",
      "antimony",
      "bauxite",
      "brass",
      "bronze",
      "charcoal",
      "chromium",
      "constantan",
      "copper",
      "diamond",
      "electrum",
      "fluorite",
      "gold",
      "graphite",
      "invar",
      "iridium",
      "iron",
      "lead",
      "lumium",
      "monazite",
      "netherite",
      "nickel",
      "obsidian",
      "osmium",
      "platinum",
      "plutonium",
      "quartz",
      "refined_glowstone",
      "silicon",
      "silver",
      "stainless_steel",
      "steel",
      "tin",
      "titanium",
      "tungsten",
      "uranium",
      "zinc",
    ],
    type: "dust",
  },
  {
    materials: [
      "aluminum",
      "antimony",
      "bauxite",
      "copper",
      "diamond",
      "emerald",
      "fluorite",
      "gold",
      "iridium",
      "iron",
      "lapis_lazuli",
      "lead",
      "monazite",
      "nickel",
      "osmium",
      "platinum",
      "quartz",
      "redstone",
      "resonating_ore",
      "silver",
      "sulfur",
      "tin",
      "titanium",
      "tungsten",
      "uranium",
      "zinc",
    ],
    type: "end_ore",
  },
  {
    materials: [
      "aluminum",
      "brass",
      "bronze",
      "chromium",
      "constantan",
      "diamond",
      "electrum",
      "gold",
      "graphite",
      "invar",
      "iron",
      "lead",
      "lumium",
      "netherite",
      "nickel",
      "obsidian",
      "osmium",
      "platinum",
      "plutonium",
      "quartz",
      "refined_glowstone",
      "silicon",
      "silver",
      "stainless_steel",
      "steel",
      "tin",
      "titanium",
      "uranium",
      "zinc",
    ],
    type: "gear",
  },
  {
    materials: [
      "aluminum",
      "antimony",
      "brass",
      "bronze",
      "chromium",
      "constantan",
      "electrum",
      "graphite",
      "invar",
      "iridium",
      "lead",
      "lumium",
      "nickel",
      "osmium",
      "platinum",
      "plutonium",
      "refined_glowstone",
      "silicon",
      "silver",
      "steel",
      "tin",
      "titanium",
      "tungsten",
      "uranium",
      "zinc",
    ],
    type: "ingot",
  },
  {
    materials: [
      "aluminum",
      "antimony",
      "bauxite",
      "copper",
      "diamond",
      "emerald",
      "fluorite",
      "gold",
      "iridium",
      "iron",
      "lapis_lazuli",
      "lead",
      "monazite",
      "nickel",
      "osmium",
      "platinum",
      "redstone",
      "resonating_ore",
      "silver",
      "sulfur",
      "tin",
      "titanium",
      "tungsten",
      "uranium",
      "zinc",
    ],
    type: "nether_ore",
  },
  {
    materials: [
      "aluminum",
      "antimony",
      "brass",
      "bronze",
      "chromium",
      "constantan",
      "copper",
      "diamond",
      "electrum",
      "graphite",
      "invar",
      "iridium",
      "lead",
      "lumium",
      "netherite",
      "nickel",
      "osmium",
      "platinum",
      "plutonium",
      "quartz",
      "refined_glowstone",
      "silicon",
      "silver",
      "steel",
      "tin",
      "titanium",
      "tungsten",
      "uranium",
      "zinc",
    ],
    type: "nugget",
  },
  {
    materials: [
      "aluminum",
      "brass",
      "bronze",
      "chromium",
      "constantan",
      "diamond",
      "electrum",
      "gold",
      "graphite",
      "invar",
      "iridium",
      "iron",
      "lead",
      "lumium",
      "netherite",
      "nickel",
      "obsidian",
      "osmium",
      "platinum",
      "plutonium",
      "quartz",
      "refined_glowstone",
      "silicon",
      "silver",
      "stainless_steel",
      "steel",
      "tin",
      "titanium",
      "tungsten",
      "uranium",
      "zinc",
    ],
    type: "plate",
  },
  {
    materials: [
      "aluminum",
      "antimony",
      "brass",
      "chromium",
      "iridium",
      "lead",
      "nickel",
      "osmium",
      "platinum",
      "plutonium",
      "silicon",
      "silver",
      "tin",
      "titanium",
      "tungsten",
      "uranium",
      "zinc",
    ],
    type: "raw_block",
  },
  {
    materials: [
      "aluminum",
      "antimony",
      "brass",
      "chromium",
      "iridium",
      "lead",
      "nickel",
      "osmium",
      "platinum",
      "plutonium",
      "silicon",
      "silver",
      "tin",
      "titanium",
      "tungsten",
      "uranium",
      "zinc",
    ],
    type: "raw_ore",
  },
  {
    materials: [
      "aluminum",
      "brass",
      "bronze",
      "chromium",
      "constantan",
      "diamond",
      "electrum",
      "gold",
      "graphite",
      "invar",
      "iron",
      "lead",
      "lumium",
      "netherite",
      "nickel",
      "obsidian",
      "osmium",
      "platinum",
      "plutonium",
      "quartz",
      "refined_glowstone",
      "silicon",
      "silver",
      "stainless_steel",
      "steel",
      "tin",
      "titanium",
      "tungsten",
      "uranium",
      "zinc",
    ],
    type: "rod",
  },
  {
    materials: [
      "aluminum",
      "antimony",
      "brass",
      "chromium",
      "diamond",
      "gold",
      "iridium",
      "iron",
      "lead",
      "lumium",
      "nickel",
      "osmium",
      "platinum",
      "plutonium",
      "quartz",
      "silicon",
      "silver",
      "sulfur",
      "tin",
      "titanium",
      "tungsten",
      "uranium",
      "zinc",
    ],
    type: "shard",
  },
  {
    materials: [
      "aluminum",
      "antimony",
      "bauxite",
      "fluorite",
      "iridium",
      "lead",
      "monazite",
      "nickel",
      "osmium",
      "platinum",
      "quartz",
      "resonating_ore",
      "silver",
      "sulfur",
      "tin",
      "titanium",
      "tungsten",
      "uranium",
      "zinc",
    ],
    type: "stone_ore",
  },
  {
    materials: [
      "aluminum",
      "antimony",
      "apatite",
      "bauxite",
      "brass",
      "bronze",
      "chromium",
      "constantan",
      "copper",
      "diamond",
      "electrum",
      "emerald",
      "fluorite",
      "gold",
      "graphite",
      "invar",
      "iridium",
      "iron",
      "lapis_lazuli",
      "lead",
      "lumium",
      "monazite",
      "netherite",
      "nickel",
      "obsidian",
      "osmium",
      "platinum",
      "plutonium",
      "quartz",
      "redstone",
      "refined_glowstone",
      "resonating_ore",
      "signalum",
      "silicon",
      "silver",
      "stainless_steel",
      "steel",
      "sulfur",
      "tin",
      "titanium",
      "tungsten",
      "uranium",
      "zinc",
    ],
    type: "wire",
  },
  {
    materials: ["apatite", "brass", "chromium", "electrum", "gold", "plutonium", "resonating_ore", "silicon", "silver"],
    type: "gem",
  },
];

