/*
 * Decompiled with CFR 0.152.
 */
package net.rocketplatform.game.client.mod.ui.template.element.type;

import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import net.minecraft.client.gui.GuiGraphics;
import net.rocketplatform.game.client.mod.ui.template.callback.ElementCallback;
import net.rocketplatform.game.client.mod.ui.template.element.ElementTemplate;
import net.rocketplatform.game.client.mod.ui.template.element.WidgetElementTemplate;
import net.rocketplatform.game.client.mod.ui.template.layout.screen.TemplateScreen;
import net.rocketplatform.game.client.mod.ui.variable.VariableStorage;
import org.joml.Vector2i;

public class ProgressBarTemplate
extends WidgetElementTemplate {
    private static final String WIDTH_KEY = "width";
    private static final String HEIGHT_KEY = "height";
    private static final int DEFAULT_WIDTH = 32;
    private static final int DEFAULT_HEIGHT = 8;
    private int value;
    private int max;

    public ProgressBarTemplate(String type, String id, ElementTemplate.Position position, ElementCallback callback) {
        super(type, id, position, callback);
    }

    public int getWidth() {
        return this.getOption(WIDTH_KEY, 32);
    }

    public int getHeight() {
        return this.getOption(HEIGHT_KEY, 8);
    }

    @Override
    public Widget createElement0(TemplateScreen screen, int elementWidth, int elementHeight, int offsetX, int offsetY, VariableStorage variableStorage) {
        Vector2i pos = this.getPivot().apply(elementWidth, elementHeight, this.getWidth(), this.getHeight());
        pos.add(offsetX + this.getPosition().x(), offsetY + this.getPosition().y());
        Widget widget = new Widget(screen.getPanel()){

            public void draw(GuiGraphics graphics, Theme theme, int x, int y, int w, int h) {
                GuiHelper.setupDrawing();
                Color4I.DARK_GRAY.draw(graphics, x - 1, y - 1, w + 2, 1);
                Color4I.DARK_GRAY.draw(graphics, x - 1, y - 1, 1, h + 2);
                Color4I.DARK_GRAY.draw(graphics, x + w, y - 1, 1, h + 2);
                Color4I.DARK_GRAY.draw(graphics, x - 1, y + h, w + 2, 1);
                int fillWidth = (int)((double)w * ((double)ProgressBarTemplate.this.value / (double)ProgressBarTemplate.this.max));
                Color4I.GREEN.draw(graphics, x + 1, y + 1, fillWidth - 2, h - 2);
                super.draw(graphics, theme, x, y, w, h);
            }
        };
        widget.setPosAndSize(pos.x(), pos.y(), this.getWidth(), this.getHeight());
        return widget;
    }
}

