/*
 * Decompiled with CFR 0.152.
 */
package net.rocketplatform.game.client.mod.ui.template.callback.type;

import com.google.gson.annotations.SerializedName;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import lombok.Generated;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.rocketplatform.client.generated.CreatePlayerServerWorldResponse;
import net.rocketplatform.client.generated.CreatePlayerServerWorldResponseError;
import net.rocketplatform.client.generated.PlayerModpackServerWorld;
import net.rocketplatform.client.generated.StartWorldUploadResponse;
import net.rocketplatform.client.generated.WorldUploadProgress;
import net.rocketplatform.client.generated.WorldUploadProgressUploadedPartInput;
import net.rocketplatform.game.client.mod.RocketClientMod;
import net.rocketplatform.game.client.mod.client.RocketClientHandler;
import net.rocketplatform.game.client.mod.ui.MultilineErrorScreen;
import net.rocketplatform.game.client.mod.ui.template.callback.CallbackHolder;
import net.rocketplatform.game.client.mod.ui.template.callback.ElementCallback;
import net.rocketplatform.game.client.mod.ui.template.layout.screen.TemplateScreen;
import net.rocketplatform.game.client.mod.ui.variable.VariableStorage;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UploadWorldCallback
extends ElementCallback {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UploadWorldCallback.class);
    @SerializedName(value="on_complete")
    private ElementCallback onComplete;

    public UploadWorldCallback(String action) {
        super(action);
    }

    @Override
    public void onPress(TemplateScreen screen, @Nullable CallbackHolder holder, VariableStorage variableStorage) {
        if (!variableStorage.contains("gameServerId")) {
            this.handleFailure("Unable to upload world: Could not find game server id.", null, null);
            return;
        }
        String gameServerId = (String)variableStorage.retrieve("gameServerId");
        if (!variableStorage.contains("selectedWorldPath")) {
            this.handleFailure("Unable to upload world: A world was not selected.", gameServerId, null);
            return;
        }
        String worldName = (String)variableStorage.retrieve("selectedWorldName");
        String worldPathName = (String)variableStorage.retrieve("selectedWorldPath");
        String modpackId = RocketClientMod.getInstance().getModpackId();
        String versionId = Integer.toString(RocketClientMod.getInstance().getPackMetadata().getVersion().getId());
        Path worldPath = Paths.get(worldPathName, new String[0]);
        ((CompletableFuture)((CompletableFuture)((CompletableFuture)RocketClientMod.getInstance().getClientHandler().thenCompose(client -> client.createPlayerServerWorld(gameServerId, worldName, modpackId, versionId).thenApply(response -> Pair.of((Object)client, (Object)response)))).thenCompose(pair -> {
            RocketClientHandler client = (RocketClientHandler)pair.getKey();
            CreatePlayerServerWorldResponse response = (CreatePlayerServerWorldResponse)pair.getValue();
            if (response == null) {
                this.handleFailure("Unable to upload world: The service failed to respond.", gameServerId, null);
                return null;
            }
            if (response.getError() != null) {
                String reason = switch (response.getError()) {
                    default -> throw new MatchException(null, null);
                    case CreatePlayerServerWorldResponseError.NO_WORLD_SLOTS -> "No world slots available.";
                    case CreatePlayerServerWorldResponseError.OTHER -> "An unknown error occurred. Please report this issue!";
                };
                this.handleFailure("Unable to upload world: " + reason, gameServerId, null);
                return null;
            }
            PlayerModpackServerWorld world = response.getWorld();
            if (world == null) {
                this.handleFailure("Unable to upload world: The service failed to respond with a world.", gameServerId, null);
                return null;
            }
            return client.startWorldUpload(gameServerId, world.getWorldId()).thenApply(uploadResponse -> Triple.of((Object)client, (Object)uploadResponse, (Object)world.getWorldId()));
        })).thenComposeAsync(triple -> {
            if (triple == null || triple.getMiddle() == null) {
                this.handleFailure("Unable to upload world: The service failed to respond.", gameServerId, triple == null ? null : (Integer)triple.getRight());
                return CompletableFuture.failedFuture(new RuntimeException("No response from server."));
            }
            RocketClientHandler client = (RocketClientHandler)triple.getLeft();
            StartWorldUploadResponse response = (StartWorldUploadResponse)triple.getMiddle();
            String uploadId = response.getWorldUploadId();
            String uploadUrl = response.getUploadUrl();
            return CompletableFuture.supplyAsync(() -> {
                StreamCompletedResponse streamCompletedResponse;
                Supplier<String> additonalUrlSupplier = () -> {
                    try {
                        return client.worldUploadNewPart(gameServerId, uploadId).get(20L, TimeUnit.SECONDS).getUploadUrl();
                    }
                    catch (InterruptedException | ExecutionException | TimeoutException e) {
                        throw new RuntimeException(e);
                    }
                };
                MultipartOutputStream outputStream = new MultipartOutputStream(uploadUrl, additonalUrlSupplier);
                try {
                    UploadWorldCallback.tarWorld(worldPath, outputStream);
                    streamCompletedResponse = new StreamCompletedResponse(client, uploadId, (Integer)triple.getRight(), outputStream.getETags());
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            outputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Unable to upload world: " + e.getMessage(), e);
                    }
                }
                outputStream.close();
                return streamCompletedResponse;
            }, Util.backgroundExecutor());
        })).whenComplete((uploadResults, e) -> {
            if (e != null) {
                RocketClientMod.getLogger().info("An error occurred uploading world", e);
                this.handleFailure("Unable to upload world: " + e.getMessage(), gameServerId, null);
                return;
            }
            try {
                RocketClientHandler client = uploadResults.client();
                String uploadId = uploadResults.uploadId();
                ArrayList<WorldUploadProgressUploadedPartInput> uploadedParts = new ArrayList<WorldUploadProgressUploadedPartInput>(uploadResults.eTags().size());
                int partNumber = 1;
                for (String eTag : uploadResults.eTags()) {
                    uploadedParts.add(WorldUploadProgressUploadedPartInput.builder().setPartNumber(Integer.valueOf(partNumber++)).setEtag(eTag).build());
                }
                client.updateWorldUploadProgress(gameServerId, uploadId, WorldUploadProgress.UPLOAD_COMPLETED, uploadedParts).whenComplete((response, ex) -> {
                    if (ex != null) {
                        this.handleFailure("Unable to upload world: " + ex.getMessage(), gameServerId, uploadResults.worldId());
                        return;
                    }
                    if (this.onComplete != null) {
                        RenderSystem.recordRenderCall(() -> CallbackHolder.runCallbacks(screen, holder, this.onComplete, variableStorage));
                    }
                });
            }
            catch (Throwable t) {
                RocketClientMod.getLogger().info("An error occurred completing world upload", t);
                this.handleFailure("Error occurred finalizing world upload: " + t.getMessage(), gameServerId, null);
            }
        });
    }

    private void handleFailure(String reason, String gameServerId, @Nullable Integer worldId) {
        RocketClientMod.getLogger().error(reason, new Throwable());
        if (worldId != null) {
            String modpackId = RocketClientMod.getInstance().getModpackId();
            String versionId = Integer.toString(RocketClientMod.getInstance().getPackMetadata().getVersion().getId());
            ((CompletableFuture)RocketClientMod.getInstance().getClientHandler().thenCompose(client -> client.deletePlayerServerWorld(gameServerId, worldId, modpackId, versionId))).whenComplete((response, e) -> {
                if (e != null) {
                    RocketClientMod.getLogger().error("Failed to delete world {}", (Object)worldId, e);
                }
            });
        }
        RenderSystem.recordRenderCall(() -> {
            MultilineErrorScreen errorScreen = new MultilineErrorScreen((Component)Component.translatable((String)"rgp_client.gui.button.ftb_worlds"), (Component)Component.literal((String)reason));
            Minecraft.getInstance().setScreen((Screen)errorScreen);
        });
    }

    private static void tarWorld(final Path source, OutputStream outputStream) throws IOException {
        if (!Files.isDirectory(source, new LinkOption[0])) {
            throw new IOException("The file provided was not a directory!");
        }
        try (BufferedOutputStream bufferedStream = new BufferedOutputStream(outputStream);
             GzipCompressorOutputStream gzipStream = new GzipCompressorOutputStream((OutputStream)bufferedStream);
             final TarArchiveOutputStream tarStream = new TarArchiveOutputStream((OutputStream)gzipStream);){
            tarStream.setLongFileMode(2);
            Files.walkFileTree(source, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attributes) {
                    if (attributes.isSymbolicLink()) {
                        return FileVisitResult.CONTINUE;
                    }
                    Path targetFile = source.relativize(file);
                    try {
                        TarArchiveEntry tarEntry = new TarArchiveEntry(file.toFile(), targetFile.toString());
                        tarStream.putArchiveEntry(tarEntry);
                        Files.copy(file, (OutputStream)tarStream);
                        tarStream.closeArchiveEntry();
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Unable to tar.gz file " + String.valueOf(file), e);
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException e) {
                    RocketClientMod.getLogger().error("Unable to tar.gz file {}", (Object)file, (Object)e);
                    return FileVisitResult.CONTINUE;
                }
            });
            tarStream.finish();
        }
    }

    private record StreamCompletedResponse(RocketClientHandler client, String uploadId, int worldId, List<String> eTags) {
    }

    private static class MultipartOutputStream
    extends OutputStream
    implements Closeable {
        private static final long BYTES_PER_STREAM = 0x8000000L;
        private final Supplier<String> additionalUrls;
        private final AtomicReference<HttpURLConnection> connection = new AtomicReference();
        private final AtomicReference<OutputStream> connectionOutputStream = new AtomicReference();
        private final AtomicLong bytesWrote = new AtomicLong();
        private final List<String> eTags = new ArrayList<String>();

        private MultipartOutputStream(@NotNull String initialUrl, @NotNull @NotNull Supplier<@NotNull String> additionalUrls) throws IOException {
            this.establishNewConnection(initialUrl);
            this.additionalUrls = additionalUrls;
        }

        @Override
        public synchronized void write(byte @NotNull [] b, int off, int len) throws IOException {
            log.trace("Writing {} bytes to connection", (Object)len);
            AtomicReference pairsForStreamsRef = new AtomicReference();
            this.bytesWrote.updateAndGet(currentBytesWrote -> {
                int currentOff = off;
                int currentLen = len;
                ArrayList<Pair> pairsForStreams = new ArrayList<Pair>();
                while (currentBytesWrote + (long)currentLen >= 0x8000000L) {
                    int bytesToWrite = (int)(0x8000000L - currentBytesWrote);
                    pairsForStreams.add(Pair.of((Object)currentOff, (Object)bytesToWrite));
                    currentLen -= bytesToWrite;
                    currentBytesWrote = 0L;
                    currentOff += bytesToWrite;
                }
                if (currentLen > 0) {
                    pairsForStreams.add(Pair.of((Object)currentOff, (Object)currentLen));
                }
                pairsForStreamsRef.set(pairsForStreams);
                return (long)currentLen + currentBytesWrote;
            });
            log.trace("Got {} pairs for streams", (Object)((List)pairsForStreamsRef.get()).size());
            Iterator iterator = ((List)pairsForStreamsRef.get()).iterator();
            while (iterator.hasNext()) {
                Pair pair = (Pair)iterator.next();
                int offForStream = (Integer)pair.getLeft();
                int lenForStream = (Integer)pair.getRight();
                log.trace("Writing {} bytes to stream Offset: {}, Bytes length: {}", new Object[]{lenForStream, offForStream, b.length});
                if (lenForStream != 0) {
                    OutputStream outputStream = this.connectionOutputStream.get();
                    outputStream.write(b, offForStream, lenForStream);
                }
                if (!iterator.hasNext()) continue;
                this.establishNewConnection(this.additionalUrls.get());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(int b) throws IOException {
            if (this.bytesWrote.getAndIncrement() >= 0x8000000L) {
                MultipartOutputStream multipartOutputStream = this;
                synchronized (multipartOutputStream) {
                    if (this.bytesWrote.get() >= 0x8000000L) {
                        this.establishNewConnection(this.additionalUrls.get());
                    }
                }
            }
            OutputStream outputStream = this.connectionOutputStream.get();
            outputStream.write(b);
        }

        private synchronized void establishNewConnection(@NotNull String uploadUrl) throws IOException {
            Validate.notNull((Object)uploadUrl, (String)"uploadUrl cannot be null", (Object[])new Object[0]);
            HttpURLConnection oldConnection = this.connection.get();
            if (oldConnection != null) {
                this.finalizeConnection();
            }
            URL url = URI.create(uploadUrl).toURL();
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setDoOutput(true);
            connection.setRequestMethod("PUT");
            connection.setRequestProperty("Content-Type", "application/tar+gzip");
            connection.setChunkedStreamingMode(8192);
            this.connection.set(connection);
            this.connectionOutputStream.set(connection.getOutputStream());
            this.bytesWrote.set(0L);
        }

        @Override
        public synchronized void close() throws IOException {
            this.finalizeConnection();
            this.connection.set(null);
            this.connectionOutputStream.set(null);
        }

        private synchronized void finalizeConnection() throws IOException {
            HttpURLConnection connection;
            OutputStream outputStream = this.connectionOutputStream.get();
            if (outputStream != null) {
                outputStream.close();
            }
            if ((connection = this.connection.get()) != null) {
                int responseCode = connection.getResponseCode();
                String responseMessage = connection.getResponseMessage().trim();
                if (responseCode < 200 || responseCode >= 300) {
                    throw new IllegalStateException("Failed to upload: HTTP " + responseCode + " (" + responseMessage + ")");
                }
                String eTag = connection.getHeaderField("ETag");
                if (eTag != null) {
                    this.eTags.add(eTag);
                } else {
                    throw new IllegalStateException("Failed to upload: No ETag returned");
                }
            }
        }

        List<String> getETags() {
            return Collections.unmodifiableList(this.eTags);
        }
    }
}

