/*
 * Decompiled with CFR 0.152.
 */
package net.rocketplatform.game.client.mod.ui.loader;

import java.nio.file.Path;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ErrorScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.storage.LevelStorageException;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.LevelSummary;
import net.rocketplatform.game.client.mod.RocketClientMod;
import net.rocketplatform.game.client.mod.ui.loader.ListEntryLoader;
import net.rocketplatform.game.client.mod.ui.template.element.ElementTemplate;
import net.rocketplatform.game.client.mod.ui.template.layout.type.AbstractListLayoutTemplate;
import net.rocketplatform.game.client.mod.ui.variable.VariableProcessor;
import net.rocketplatform.game.client.mod.ui.variable.VariableStorage;
import org.jetbrains.annotations.Nullable;

public class SingleplayerWorldEntryLoader
extends ListEntryLoader {
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat();

    public SingleplayerWorldEntryLoader(String type, AbstractListLayoutTemplate.ListEntry entryTemplate) {
        super(type, entryTemplate);
    }

    @Override
    public CompletableFuture<List<ListEntryLoader.ListEntryTemplate>> loadEntries(@Nullable VariableStorage storage) {
        AbstractListLayoutTemplate.ListEntry entryTemplate = this.getEntryTemplate();
        if (storage == null) {
            RocketClientMod.getLogger().warn("No storage provided for singleplayer world list entry loader, so no entries will be loaded.");
            return CompletableFuture.completedFuture(List.of());
        }
        return SingleplayerWorldEntryLoader.loadLevels().thenApply(levels -> {
            if (levels.isEmpty()) {
                return List.of();
            }
            ArrayList<ListEntryLoader.ListEntryTemplate> entries = new ArrayList<ListEntryLoader.ListEntryTemplate>();
            for (LevelSummary level : levels) {
                Path levelPath = Minecraft.getInstance().getLevelSource().getBaseDir().resolve(level.getLevelId());
                VariableStorage worldStorage = new VariableStorage();
                worldStorage.store("worldPath", levelPath.toString());
                worldStorage.store("worldId", level.getLevelId());
                worldStorage.store("worldName", level.getLevelName());
                worldStorage.store("worldInfo", level.getInfo().getString());
                worldStorage.store("worldIcon", level.getIcon().toUri());
                worldStorage.store("worldLastPlayed", DATE_FORMAT.format(new Date(level.getLastPlayed())));
                worldStorage.store("worldGameMode", level.getGameMode().getName());
                List<ElementTemplate<?>> elements = SingleplayerWorldEntryLoader.processElements(entryTemplate, worldStorage);
                AbstractListLayoutTemplate.ListEntry entry = new AbstractListLayoutTemplate.ListEntry(VariableProcessor.process(entryTemplate.getId(), worldStorage), elements, entryTemplate.requiredDoubleClickVariable(), entryTemplate.getCallback(), entryTemplate.selectedCallback());
                entries.add(new ListEntryLoader.ListEntryTemplate(entry, worldStorage));
            }
            return entries;
        });
    }

    private static CompletableFuture<List<LevelSummary>> loadLevels() {
        LevelStorageSource.LevelCandidates candidates;
        try {
            candidates = Minecraft.getInstance().getLevelSource().findLevelCandidates();
        }
        catch (LevelStorageException e) {
            RocketClientMod.getLogger().error("Couldn't load level list", (Throwable)e);
            SingleplayerWorldEntryLoader.handleLevelLoadFailure(e.getMessageComponent());
            return CompletableFuture.completedFuture(List.of());
        }
        if (candidates.isEmpty()) {
            return CompletableFuture.completedFuture(List.of());
        }
        return Minecraft.getInstance().getLevelSource().loadLevelSummaries(candidates).exceptionally(throwable -> List.of());
    }

    private static void handleLevelLoadFailure(Component exceptionMessage) {
        Minecraft.getInstance().setScreen((Screen)new ErrorScreen((Component)Component.translatable((String)"selectWorld.unable_to_load"), exceptionMessage));
    }
}

